<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class SeoTemplateTemplateLanguage extends Model 
{

    protected $table = 'lim_seo_template_languages';
    public $timestamps = true;
    protected $fillable = array('lim_language_id', 'lim_seo_template_id', 'name');
    protected $visible = array('lim_language_id', 'lim_seo_template_id', 'name');

    public function language()
    {
        return $this->belongsTo('App\Models\Language', 'lim_language_id');
    }

    public function template()
    {
        return $this->belongsTo('App\Models\SeoTemplate', 'lim_seo_template_id');
    }

}